// Countdown global reutilizável
let countdownMinutes = 15; // Defina aqui a quantidade de minutos do countdown
const COUNTDOWN_KEY = 'glucovita_countdown_expire';

function getExpireTimestamp() {
    let expire = localStorage.getItem(COUNTDOWN_KEY);
    if (!expire) {
        const now = Date.now();
        expire = now + countdownMinutes * 60 * 1000;
        localStorage.setItem(COUNTDOWN_KEY, expire);
    }
    return parseInt(expire, 10);
}

function updateCountdown() {
    const expire = getExpireTimestamp();
    const now = Date.now();
    let diff = Math.max(0, Math.floor((expire - now) / 1000));
    const min = String(Math.floor(diff / 60)).padStart(2, '0');
    const sec = String(diff % 60).padStart(2, '0');
    $('.countdown').text(`${min}:${sec}`);

    if (diff <= 0) {
        // Reiniciar o countdown
        localStorage.removeItem(COUNTDOWN_KEY);
        updateCountdown();
    }
    setTimeout(updateCountdown, 500);
}

$(document).ready(() => {
    $('.faq__question').on('click', function () {
        const $btn = $(this);
        const $item = $btn.closest('.faq__item');
        const $answer = $item.find('.faq__answer');
        const isOpen = $btn.attr('aria-expanded') === 'true';

        // Fecha todos
        $('.faq__question').attr('aria-expanded', 'false');
        $('.faq__answer').slideUp(200);
        $('.faq__question img').css('transform', 'rotate(0deg)');

        // Se estava fechado, abre
        if (!isOpen) {
            $btn.attr('aria-expanded', 'true');
            $answer.slideDown(100);
            $btn.find('img').css('transform', 'rotate(180deg)');
        }
    });

    // Garante que todas as respostas começam fechadas
    $('.faq__answer').hide();

    updateCountdown();
});
