const NOTIFICATIONS = [
    { name: 'John Smith', time: 'just bought' },
    { name: 'Mary Johnson', time: 'just bought' },
    { name: 'William Brown', time: 'just bought' },
    { name: 'Patricia Davis', time: 'just bought' },
    { name: 'James Wilson', time: 'just bought' },
    { name: 'Jennifer Moore', time: 'just bought' },
    { name: 'Michael Taylor', time: 'just bought' },
    { name: 'Linda Anderson', time: 'just bought' },
    { name: 'David Thomas', time: 'just bought' },
    { name: 'Elizabeth Jackson', time: 'just bought' },
    { name: 'Joseph White', time: 'just bought' },
    { name: 'Susan Harris', time: 'just bought' },
    { name: 'Thomas Martin', time: 'just bought' },
    { name: 'Dorothy Thompson', time: 'just bought' },
    { name: 'Charles Garcia', time: 'just bought' },
    { name: 'Betty Martinez', time: 'just bought' },
    { name: 'Richard Robinson', time: 'just bought' },
    { name: 'Helen Clark', time: 'just bought' },
    { name: 'Edward Lewis', time: 'just bought' }
];

const NOTIFICATION_TIMEOUT = 5000;
const NOTIFICATION_INTERVAL = 15000;

class NotificationManager {
    constructor() {
        this.notificationIndex = 0;
        this.notification = $('.notification');
        this.hideTimeout = null;
    }

    showNotification = () => {
        const { name, time } = NOTIFICATIONS[this.notificationIndex];
        
        this.notification
            .find('.notification__name')
            .text(name);
            
        this.notification
            .find('.notification__time')
            .text(time);

        this.notificationIndex = (this.notificationIndex + 1) % NOTIFICATIONS.length;
        this.notification.addClass('notification--active');

        this.hideTimeout = setTimeout(
            () => this.notification.removeClass('notification--active'),
            NOTIFICATION_TIMEOUT
        );
    };

    setupEventListeners = () => {
        this.notification
            .find('.notification__close')
            .on('click', () => {
                this.notification.removeClass('notification--active');
                clearTimeout(this.hideTimeout);
            });
    };

    start = () => {
        this.showNotification();
        this.setupEventListeners();

        setInterval(
            () => this.showNotification(),
            NOTIFICATION_INTERVAL
        );
    };
}

const notificationManager = new NotificationManager();
notificationManager.start();
